# Reto 01 - Tarjeta de producto

**Nivel 1: 👶🏽 Bebé Dev**

![Project image](<final/Desktop 1280.png>)

¡Hola dev! Gracias por descargar este reto de StreamByte. Para resolverlo, necesitas conocer las bases de HTML y CSS. Este reto te ayudará a mejorar tus habilidades en Front-End al replicar proyectos realistas.

## ¿Qué construirás?

El reto es construir una tarjeta de previsualización de producto y que sea lo más parecida posible al diseño. Si llevas poco tiempo en el mundo del desarrollo. Te recomendamos no utilizar ningún framework ni pre-procesador y resolverlo utilizando HTML y CSS solamente.

Para resolver este reto es necesario completar los siguientes criterios:

1. El componente de la tarjeta debe estar completamente centrado en la página.
2. El espaciado y alineación del texto debe seguir las convenciones del diseño.
3. Asegúrate de replicar el comportamiento (solo estilos) de los botones `Añadir al carrito` y `Dar like`. (Puedes ver el prototipo en Figma).
4. El proyecto debe contener en su archivo de estilos las variables especificadas en `DESIGN_SYSTEM.md`.
5. Las imágenes deben estar optimizadas y tipografías añadidas a tu criterio. Todos los elementos del diseño se encuentran en la carpeta `/assets`.
6. Debes publicar el sitio.

### Te invitamos a mejorarlo

Si ya tienes experiencia utilizando HTML y CSS o solo te gustaría practicar otra tecnología. Te invitamos a añadir secciones o funcionalidades a este proyecto, solo recuerda seguir el sistema de diseño.

Puedes publicar tu solución en nuestro Discord o subirla al repositorio de soluciones de la comunidad. Las más votadas aparecerán próximamente en el `Leaderboard`.

### Usa como quieras

Si te encuentras haciendo un trabajo o proyecto personal donde puedas aplicar algo de lo aprendido. No dudes en usar o modificar los recursos dados para este reto.

## instrucciones

Puedes utilizar la metodología de trabajo que prefieras para completar. Aunque te sugerimos el siguiente proceso en caso de dudas:

1. Copia la carpeta `/Reto 01 - Tarjeta de producto` del archivo que descargaste dentro de tu editor de código favorito. Recomendamos [VS Code](https://code.visualstudio.com/).
2. Crea un repositorio nuevo en [GitHub](https://github.com/) con el nombre del proyecto.
3. Después de leer la documentación. Revisa el diseño de Figma exhaustivamente, este paso ayuda a adelantar el proceso y nos da ideas de que clases de CSS son aplicables.
4. Estructura el contenido con HTML.
5. Agrega estilos con CSS. Trabaja por secciones, no pases a la siguiente hasta que estés satisfecho con la anterior.
6. Una vez que hayas completado el código, sube los cambios al repositorio del proyecto.
7. Crea un archivo `README.md` personalizado. Aquí debes detallar toda la información necesaria de tu proyecto.
8. Publica el sitio.
9. Modifica y utiliza a tu gusto.

Puedes ver capturas del diseño terminado en la carpeta `final`.

Recuerda que puedes pedir apoyo a la comunidad.

## Gracias por compartir

Si encuentras los retos creados por StreamByte entretenidos o útiles, recuerda compartirlo con ese amigo que podría practicar más Front-End. Si tienes algo que mencionarnos o ideas para mejorar el proyecto, no dudes en contactarnos.

###### Pásalo lindo codeando 💚